/*
 * Created on Aug 19, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package Validators;

import DataClasses.*;
/**
 * @author student
 *
 * This class is being used for validating the user user details.
 * 
 */
public class UserValidator {
	
	private String message;
	
	/**
	 * This method is being used for getting the error if the validation was
	 * unsucessful.
	 * @return String The message to be displayed.
	 */
	public String getMessage(){
		return message;
	}
	/**
	 * This method is being used for setting the error message.
	 * @param message The message to be displayed.
	 * @return void
	 */
	public void setMessage(String message){
		this.message = message;
	}
	
	/**
	 * This method is being used for validation of user details.
	 * @param userData The user details that are to be validated.
	 * @return boolean Specifies whether the validation was successful.
	 */
	public boolean validate(User_Data userData){
		
		User_Data userdata = userData;
		String firstName ,lastName, type, organisation, username;
		
		firstName = userdata.getFirstName();
		lastName = userdata.getLastName();
		type = userdata.getType();
		organisation = userdata.getOrganisation();
		username = userdata.getUserName();
		
		System.out.println("Customer Validate: firstName "+firstName);
		System.out.println("Customer Validate: lastName "+lastName);
				
		if(userdata.getType().equals("Person")){
			if(firstName.equals("") || lastName.equals("") ){
				message = "Either first name or last name is empty. ";
				return false;
			}
			if(!firstName.matches("^[a-zA-Z/`/'/-/,/./// ]{1,255}+$")){
				message = "First name has invalid characters.";
				message += " First name has to be less than 255 characters. ";
				return false;
			}
			if(!lastName.matches("^[a-zA-Z/`/'/-/,/./// ]{1,50}+$")){
				message = "Last name has invalid characters.";
				message += " Last name has to be less than 50 characters. ";
				return false;
			}
		}
		else if(userData.getType().equals("Organisation")){
			if(organisation.equals("")){
				message = "Organisation name field is empty. ";
				return false;
			}
			if(!organisation.matches("^[a-zA-Z/`/'/-/,/./!/%/// ]{1,255}+$")){
				message = "Organisation has invalid characters.";
				message += " Organisation name has to be less than 255 characters. ";
				return false;
			}
		}
		
		if(!username.matches("^[a-zA-Z/0-9/`/'/-/,/./ ]{4,8}+$")){
			message = "User name has invalid characters.";
			message += " User name has to be between 4 and 8 characters long. ";
			return false;
		}
		return true;
			
		
	}

}
